<?php
	/**
	 * The header for our theme.
	 *
	 * This is the template that displays all of the <head> section and everything up until <div id="content">
	 *
	 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
	 *
	 * @package Theme Palace
	 * @subpackage  Rise Magazine
	 * @since  Rise Magazine 1.0.0
	 */

	/**
	 * rise_magazine_doctype hook
	 *
	 * @hooked rise_magazine_doctype -  10
	 *
	 */
	do_action( 'rise_magazine_doctype' );

?>
<head>
<?php
	/**
	 * rise_magazine_before_wp_head hook
	 *
	 * @hooked rise_magazine_head -  10
	 *
	 */
	do_action( 'rise_magazine_before_wp_head' );

	wp_head(); 
?>
</head>

<body <?php body_class(); ?>>

<?php do_action( 'wp_body_open' ); ?>
<?php
	/**
	 * rise_magazine_page_start_action hook
	 *
	 * @hooked rise_magazine_page_start -  10
	 *
	 */
	do_action( 'rise_magazine_page_start_action' ); 

	/**
	 * rise_magazine_loader_action hook
	 *
	 * @hooked rise_magazine_loader -  10
	 *
	 */
	do_action( 'rise_magazine_before_header' );

	/**
	 * rise_magazine_header_action hook
	 *
	 * @hooked rise_magazine_site_branding -  10
	 * @hooked rise_magazine_header_start -  20
	 * @hooked rise_magazine_site_navigation -  30
	 * @hooked rise_magazine_header_end -  50
	 *
	 */
	do_action( 'rise_magazine_header_action' );

	/**
	 * rise_magazine_content_start_action hook
	 *
	 * @hooked rise_magazine_content_start -  10
	 *
	 */
	do_action( 'rise_magazine_content_start_action' );

    /**
     * rise_magazine_header_image_action hook
     *
     * @hooked rise_magazine_header_image -  10
     *
     */
    do_action( 'rise_magazine_header_image_action' );
	
