<?php
/**
 * Breaking News Section options
 *
 * @package Theme Palace
 * @subpackage Rise Magazine
 * @since Rise Magazine 1.0.0
 */

// Add Breaking News section
$wp_customize->add_section( 'rise_magazine_breaking_news_section',
    array(
        'title'             => esc_html__( 'Breaking News','rise-magazine' ),
        'description'       => esc_html__( 'Breaking News Section Options.', 'rise-magazine' ),
        'panel'             => 'rise_magazine_front_page_panel',
    )
);

// Breaking News content enable control and setting
$wp_customize->add_setting( 'rise_magazine_theme_options[breaking_news_section_enable]',
    array(
        'default'           =>  $options['breaking_news_section_enable'],
        'sanitize_callback' => 'rise_magazine_sanitize_switch_control',
    )
);

$wp_customize->add_control( new Rise_Magazine_Switch_Control( $wp_customize,
    'rise_magazine_theme_options[breaking_news_section_enable]',
        array(
            'label'             => esc_html__( 'Breaking News Section Enable', 'rise-magazine' ),
            'section'           => 'rise_magazine_breaking_news_section',
            'on_off_label'      => rise_magazine_switch_options(),
        ) 
    )
);

// Featured Slider autoplay enable control and setting
$wp_customize->add_setting( 'rise_magazine_theme_options[breaking_news_autoplay_enable]',
	array(
		'default'			=> 	$options['breaking_news_autoplay_enable'],
		'sanitize_callback' => 'rise_magazine_sanitize_switch_control',
	)
);

$wp_customize->add_control( new  Rise_Magazine_Switch_Control( $wp_customize,
	'rise_magazine_theme_options[breaking_news_autoplay_enable]',
		array(
			'label'             => esc_html__( 'Enable Autoplay', 'rise-magazine' ),
			'section'           => 'rise_magazine_breaking_news_section',
			'active_callback'   => 'rise_magazine_is_breaking_news_section_enable',
			'on_off_label' 		=> rise_magazine_switch_options(),
		)
	)
);
// breaking_news title setting and control
$wp_customize->add_setting( 'rise_magazine_theme_options[breaking_news_title]',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'			=> $options['breaking_news_title'],
		'transport'			=> 'postMessage',
	)
);

$wp_customize->add_control( 'rise_magazine_theme_options[breaking_news_title]',
	array(
		'label'           	=> esc_html__( 'Title', 'rise-magazine' ),
		'section'        	=> 'rise_magazine_breaking_news_section',
		'active_callback' 	=> 'rise_magazine_is_breaking_news_section_enable',
		'type'				=> 'text',
	)
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'rise_magazine_theme_options[breaking_news_title]',
		array(
			'selector'            => '#rise_magazine_breaking_news_section .breaking-news-wrapper h2.news-title',
			'settings'            => 'rise_magazine_theme_options[breaking_news_title]',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
			'render_callback'     => 'rise_magazine_breaking_news_title_partial',
		)
	);
}

// Add dropdown category setting and control.
$wp_customize->add_setting(  'rise_magazine_theme_options[breaking_news_content_category]',
    array(
        'sanitize_callback' => 'rise_magazine_sanitize_single_category',
    )
);

$wp_customize->add_control( new Rise_Magazine_Dropdown_Taxonomies_Control( $wp_customize,
    'rise_magazine_theme_options[breaking_news_content_category]',
        array(
            'label'             => esc_html__( 'Select Category', 'rise-magazine' ),
            'description'       => esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'rise-magazine' ),
            'section'           => 'rise_magazine_breaking_news_section',
            'type'              => 'dropdown-taxonomies',
            'active_callback'   => 'rise_magazine_is_breaking_news_section_enable'
        )
    )
);
