<?php
/**
 * pagination options
 *
 * @package Theme Palace
 * @subpackage  Rise Magazine
 * @since  Rise Magazine 1.0.0
 */

// Add sidebar section
$wp_customize->add_section( 'rise_magazine_pagination',
	array(
		'title'               	=> esc_html__('Pagination','rise-magazine'),
		'description'         	=> esc_html__( 'Pagination section options.', 'rise-magazine' ),
		'panel'               	=> 'rise_magazine_theme_options_panel',
	)
);

// Sidebar position setting and control.
$wp_customize->add_setting( 'rise_magazine_theme_options[pagination_enable]',
	array(
		'sanitize_callback' 	=> 'rise_magazine_sanitize_switch_control',
		'default'             	=> $options['pagination_enable'],
	)
);

$wp_customize->add_control( new  Rise_Magazine_Switch_Control( $wp_customize,
	'rise_magazine_theme_options[pagination_enable]',
		array(
			'label'               	=> esc_html__( 'Pagination Enable', 'rise-magazine' ),
			'section'             	=> 'rise_magazine_pagination',
			'on_off_label' 			=> rise_magazine_switch_options(),
		)
	)
);

// Site layout setting and control.
$wp_customize->add_setting( 'rise_magazine_theme_options[pagination_type]',
	array(
		'sanitize_callback'   	=> 'rise_magazine_sanitize_select',
		'default'             	=> $options['pagination_type'],
	)
);

$wp_customize->add_control( 'rise_magazine_theme_options[pagination_type]',
	array(
		'label'               	=> esc_html__( 'Pagination Type', 'rise-magazine' ),
		'section'             	=> 'rise_magazine_pagination',
		'type'                	=> 'select',
		'choices'			  	=> rise_magazine_pagination_options(),
		'active_callback'	  	=> 'rise_magazine_is_pagination_enable',
	)
);
