<?php
/**
 * Blog section
 *
 * This is the template for the content of featured_article section
 *
 * @package Theme Palace
 * @subpackage  Rise Magazine
 * @since  Rise Magazine 1.0.0
 */
if ( ! function_exists( 'rise_magazine_add_featured_article_section' ) ) :
    /**
    * Add featured_article section
    *
    *@since  Rise Magazine 1.0.0
    */
    function rise_magazine_add_featured_article_section() {
        $options = rise_magazine_get_theme_options();
        // Check if featured_article is enabled on frontpage
        $featured_article_enable = apply_filters( 'rise_magazine_section_status', true, 'featured_article_section_enable' );

        if ( true !== $featured_article_enable ) {
            return false;
        }
        // Get featured_article section details
        $section_details = array();
        $section_details = apply_filters( 'rise_magazine_filter_featured_article_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }
        // Render featured_article section now.
        rise_magazine_render_featured_article_section( $section_details );
    }
endif;

if ( ! function_exists( 'rise_magazine_get_featured_article_section_details' ) ) :
    /**
    * featured_article section details.
    *
    * @since  Rise Magazine 1.0.0
    * @param array $input featured_article section details.
    */
    function rise_magazine_get_featured_article_section_details( $input ) {
        $options = rise_magazine_get_theme_options();

        // Content type.
        $featured_article_count = 3;
        
        $content = array();
        $post_ids = array();

        for ( $i = 1; $i <= $featured_article_count; $i++ ) {
            if ( ! empty( $options['featured_article_content_post_' . $i] ) )
                $post_ids[] = $options['featured_article_content_post_' . $i];
        }
        
        $args = array(
            'post_type'             => 'post',
            'post__in'              => ( array ) $post_ids,
            'posts_per_page'        => absint( $featured_article_count ),
            'orderby'               => 'post__in',
            'ignore_sticky_posts'   => true,
        );                    

        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['excerpt']   = rise_magazine_trim_content( $options['featured_article_excerpt_length']);
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'medium_large' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-600x450.jpg';
                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// featured_article section content details.
add_filter( 'rise_magazine_filter_featured_article_section_details', 'rise_magazine_get_featured_article_section_details' );


if ( ! function_exists( 'rise_magazine_render_featured_article_section' ) ) :
  /**
   * Start featured_article section
   *
   * @return string featured_article content
   * @since  Rise Magazine 1.0.0
   *
   */
   function rise_magazine_render_featured_article_section( $content_details = array() ) {
        $options                = rise_magazine_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } ?>
        
            <div id="magazine_pro_featured_article_section" class="page-section same-background">
                <div class="wrapper">
                    <?php if ( !empty( $options['featured_article_title'] ) ): ?>
                        <div class="section-header">
                            <h2 class="section-title"><?php echo esc_html( $options['featured_article_title'] ); ?></h2>
                        </div><!-- .section-header -->
                    <?php endif ?>
                    

                    <div class="section-content col-3">
                    <?php foreach($content_details as $content): ?>
                        <article class="has-post-thumbnail">
                            <div class="featured-wrapper">
                                <div class="featured-image">
                                    <a href="<?php echo esc_url($content['url']); ?>"><img src="<?php echo esc_url($content['image']); ?>" alt="<?php echo esc_attr($content['title']) ?>"></a>
                                </div><!-- .featured-image -->

                                <div class="entry-container">
                                    <div class="header-wrapper">
                                        <header class="entry-header">
                                            <h2 class="entry-title"><a href="<?php echo esc_url($content['url']);?>" tabindex="0"><?php echo esc_html($content['title']) ?></a></h2>
                                        </header><!-- .entry-header -->

                                        <div class="entry-meta">
                                            <?php rise_magazine_posted_on($content['id']); ?>
                                        </div><!-- .entry-meta -->
                                    </div><!-- .header-wrapper -->

                                    <div class="entry-content">
                                        <p><?php echo wp_kses_post( $content['excerpt'] ); ?></p>
                                    </div><!-- .entry-content -->
                                </div><!-- .entry-container -->
                            </div><!-- .featured-wrapper -->
                        </article>
                        <?php endforeach; ?>

                    </div><!-- .section-content -->
                </div><!-- .wrapper -->
            </div><!-- #magazine_pro_featured_article_section -->
            
    <?php }
endif;  ?>
