<?php
/**
 * Must Read  section
 *
 * This is the template for the content of main_post section
 *
 * @package Theme Palace
 * @subpackage Rise Magazine
 * @since Rise Magazine 1.0.0
 */
if ( ! function_exists( 'rise_magazine_add_main_post_section' ) ) :
    /**
    * Add main_post section
    *
    *@since Rise Magazine 1.0.0
    */
    function rise_magazine_add_main_post_section() { 
        $options = rise_magazine_get_theme_options();?>
            <div id="main-post-wrapper" class="wrapper page-section same-background">
      
                <?php if(is_active_sidebar( 'main-post-section-left-sidebar' )) : ?>
                    <aside id="left-sidebar" class="widget-area" role="complementary">
                        <?php dynamic_sidebar( 'main-post-section-left-sidebar' ); ?>
                    </aside><!-- #left-sidebar -->
                <?php endif ; ?>
                <div id="primary" class="content-area">
                    <main id="main" class="site-main" role="main">
                        <?php rise_magazine_add_post_slider_section(); ?>
                        <?php rise_magazine_add_media_posts_section(); ?>
                        <?php rise_magazine_add_latest_posts_section(); ?>
                    </main>
                </div><!-- #primary -->
                <?php if(is_active_sidebar( 'main-post-section-right-sidebar' )) : ?>
                    <aside id="secondary" class="widget-area right-sidebar" role="complementary">
                        <?php dynamic_sidebar( 'main-post-section-right-sidebar' ); ?>
                    </aside><!-- #secondary -->
                <?php endif ; ?>

            </div><!-- #inner-content-wrapper -->
        
    <?php }

endif;