<?php
/**
 * Editor's Choice Widget
 *
 * @package Theme Palace
 * @subpackage Rise Magazine
 * @since Rise Magazine 1.0.0
 */

if ( ! class_exists( 'Rise_Magazine_Trending_Post' ) ) :

     
    class Rise_Magazine_Trending_Post extends WP_Widget {
        /**
         * Sets up the widgets name etc
         */
        public $default_title   = '';

        public function __construct() {
            $tp_widget_trending_post = array(
                'classname' => 'widget_recent_news',
                'description' => esc_html__( 'Retrive Trending Post.', 'rise-magazine' ),
            );
            $this->default_title = __( 'Top Posts &amp; Pages', 'rise-magazine' );

            parent::__construct( 'widget_recent_news', esc_html__( 'TP : Trending Post', 'rise-magazine' ), $tp_widget_trending_post );

        }

        function form( $instance ) {

            $instance = wp_parse_args( (array) $instance, $this->defaults() );
    
            if ( false === $instance['title'] ) {
                $instance['title'] = $this->default_title;
            }
            $title = stripslashes( $instance['title'] );
    
            $count = isset( $instance['count'] ) ? (int) $instance['count'] : 10;
            if ( $count < 1 || 10 < $count ) {
                $count = 10;
            }
    
            $tp_category        = isset( $instance['category'] ) ? absint( $instance['category'] ) : '';

            ?>
            <p>
                <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php esc_html_e( 'Title:', 'rise-magazine' ); ?></label>
                <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
            </p>

            <p id="select-category">
                <label for="<?php echo esc_attr( $this->get_field_id( 'category' ) ); ?>"><?php esc_html_e( 'Select the category to show posts:', 'rise-magazine' ); ?></label>
                <select id="<?php echo esc_attr( $this->get_field_id('category') ); ?>" name="<?php echo $this->get_field_name('category'); ?>" class="widefat" style="width:100%;">

                    <?php 
                    $categories = rise_magazine_category_choices();
                    foreach($categories as $category => $value) { ?>
                    <option value="<?php echo absint( $category ); ?>" <?php selected( (string) $tp_category, (string) $category ); ?>><?php echo esc_html( $value ); ?></option>
                    <?php } ?>      
                </select>
            </p>
            <?php
    
        }

        function widget( $args, $instance ) {
    
            $instance = wp_parse_args( (array) $instance, $this->defaults() );
    
            $title = isset( $instance['title'] ) ? $instance['title'] : false;
            if ( false === $title ) {
                $title = $this->default_title;
            }
            /** This filter is documented in core/src/wp-includes/default-widgets.php */
            $title = apply_filters( 'widget_title', $title );

            $category = isset( $instance['category'] ) ? (int) $instance['category'] : 0;

            /**
             * Control the number of displayed posts.
             *
             * @module widgets
             *
             * @since 3.3.0
             *
             * @param string $count Number of Posts displayed in the Top Posts widget. Default is 10.
             */
    
 
            
           echo $args['before_widget'];
                if ( ! empty( $title ) ) {
                    echo $args['before_title'] . esc_html( $title ) . $args['after_title'];
                }
            $post_args = array();
            if( $category != '' ){
                $post_args = array(
                    'numberposts' => 5,
                    'post_type'   => 'post',
                    'category'    => (array) $category,
                    'order'       => 'ASC',
                );           
            }  
            $posts = get_posts( $post_args ); ?>
            <ul>
            <?php foreach($posts as $index=>$post) : ?>
                <li>
                    <a href="<?php echo esc_url( get_permalink($post->ID) );?>">
                        <img src="<?php echo has_post_thumbnail( $post->ID ) ? get_the_post_thumbnail_url( $post->ID, 'medium_large') : get_template_directory_uri() .'/assets/uploads/no-featured-image-600x450.jpg'; ?>" alt="<?php echo esc_attr($post->post_title); ?>">
                    </a>
                    <div class="entry-container">
                        <div class="entry-meta">
                           <span class="cat-links">
                                <?php   the_category('', '', $post->ID ); ?>
                            </span><!-- .cat-links -->
                        </div><!-- .entry-meta -->

                        <header class="entry-header">
                            <h2 class="entry-title"><a href="<?php echo esc_url( get_permalink($post->ID) );?>"><?php echo $post->post_title; ?></a></h2>
                        </header>
                    </div><!-- .entry-container -->
                </li>
            <?php endforeach; ?>
            </ul>
            <?php wp_reset_postdata(); ?> 

            <?php echo $args['after_widget'];
        }
    
     
        function update( $new_instance, $old_instance ) {


            // processes widget options to be saved
            $instance          = array();
            $instance['title'] = wp_kses( $new_instance['title'], array() );
            if ( $instance['title'] === $this->default_title ) {
                $instance['title'] = false; // Store as false in case of language change
            }
    
            $instance['count'] = (int) $new_instance['count'];
            if ( $instance['count'] < 1 || 10 < $instance['count'] ) {
                $instance['count'] = 10;
            }

            $instance['category'] = rise_magazine_sanitize_single_category( $new_instance['category'] );
    
            return $instance;
        } 
         
        public static function defaults() {
            return array(
                'title'    => esc_html__( 'Trending Post ', 'rise-magazine' ),
                'count'    => absint( 4 ),
                'types'    => 'post',
                'category'  => '',
                
            );
        }
    
    }
endif;
