<?php
/**
 * Customizer active callbacks
 *
 * @package Theme Palace
 * @subpackage  Rise Magazine
 * @since  Rise Magazine 1.0.0
 */

if ( ! function_exists( 'rise_magazine_is_static_homepage_enable' ) ) :
	/**
	 * Check if static homepage is enabled.
	 *
	 * @since Rise Magazine 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function rise_magazine_is_static_homepage_enable( $control ) {
		return ( 'page' == $control->manager->get_setting( 'show_on_front' )->value() );
	}
endif;

if ( ! function_exists( 'rise_magazine_is_breadcrumb_enable' ) ) :
	/**
	 * Check if breadcrumb is enabled.
	 *
	 * @since  Rise Magazine 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function rise_magazine_is_breadcrumb_enable( $control ) {
		return $control->manager->get_setting( 'rise_magazine_theme_options[breadcrumb_enable]' )->value();
	}
endif;

if ( ! function_exists( 'rise_magazine_is_pagination_enable' ) ) :
	/**
	 * Check if pagination is enabled.
	 *
	 * @since  Rise Magazine 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function rise_magazine_is_pagination_enable( $control ) {
		return $control->manager->get_setting( 'rise_magazine_theme_options[pagination_enable]' )->value();
	}
endif;

/**
 * Check if hero slider section is enabled.
 *
 * @since  Rise Magazine 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function rise_magazine_is_hero_banner_section_enable( $control ) {
	return ( $control->manager->get_setting( 'rise_magazine_theme_options[hero_banner_section_enable]' )->value() );
}

/*
/**
 * Check if related_posts section is enabled.
 *
 * @since  Rise Magazine 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function rise_magazine_is_related_posts_section_enable( $control ) {
	return ( $control->manager->get_setting( 'rise_magazine_theme_options[related_posts_section_enable]' )->value() );
}

/**
 * Check if related_posts section content type is post.
 *
 * @since  Rise Magazine 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function rise_magazine_is_related_posts_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'rise_magazine_theme_options[related_posts_content_type]' )->value();
	return rise_magazine_is_related_posts_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if related_posts section content type is page.
 *
 * @since  Rise Magazine 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function rise_magazine_is_related_posts_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'rise_magazine_theme_options[related_posts_content_type]' )->value();
	return rise_magazine_is_related_posts_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if related_posts section content type is category.
 *
 * @since  Rise Magazine 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function rise_magazine_is_related_posts_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'rise_magazine_theme_options[related_posts_content_type]' )->value();
	return rise_magazine_is_related_posts_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if related_posts section content type is recent.
 *
 * @since  Rise Magazine 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function rise_magazine_is_related_posts_section_content_recent_enable( $control ) {
	$content_type = $control->manager->get_setting( 'rise_magazine_theme_options[related_posts_content_type]' )->value();
	return rise_magazine_is_related_posts_section_enable( $control ) && ( 'recent' == $content_type );
}
/**
 * Check if related_posts separator section is enabled.
 *
 * @since  Rise Magazine 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function rise_magazine_is_related_posts_section_separator_enable( $control ) {
    $content_type = $control->manager->get_setting( 'rise_magazine_theme_options[related_posts_content_type]' )->value();
    return rise_magazine_is_related_posts_section_enable( $control ) && !( 'recent' == $content_type || 'category' == $content_type ) ;
}

/**
 * Check if latest_posts section is enabled.
 *
 * @since  Rise Magazine 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function rise_magazine_is_latest_posts_section_enable( $control ) {
	return ( $control->manager->get_setting( 'rise_magazine_theme_options[latest_posts_section_enable]' )->value() );
}

/**
 * Check if top_news section is enabled.
 *
 * @since  Rise Magazine 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function rise_magazine_is_top_news_section_enable( $control ) {
	return ( $control->manager->get_setting( 'rise_magazine_theme_options[top_news_section_enable]' )->value() );
}

/**
 * Check if breaking_news section is enabled.
 *
 * @since  Rise Magazine 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function rise_magazine_is_breaking_news_section_enable( $control ) {
	return ( $control->manager->get_setting( 'rise_magazine_theme_options[breaking_news_section_enable]' )->value() );
}

/**
 * Check if featured_article section is enabled.
 *
 * @since  Rise Magazine 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function rise_magazine_is_featured_article_section_enable( $control ) {
	return ( $control->manager->get_setting( 'rise_magazine_theme_options[featured_article_section_enable]' )->value() );
}

/**
 * Check if slider section is enabled.
 *
 * @since  Rise Magazine 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function rise_magazine_is_post_slider_section_enable( $control ) {
	return ( $control->manager->get_setting( 'rise_magazine_theme_options[post_slider_section_enable]' )->value() );
}

/**
 * Check if media_posts section is enabled.
 *
 * @since  Rise Magazine 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function rise_magazine_is_media_posts_section_enable( $control ) {
	return ( $control->manager->get_setting( 'rise_magazine_theme_options[media_posts_section_enable]' )->value() );
}
