<?php
/**
 * Customizer default options
 *
 * @package Theme Palace
 * @subpackage  Rise Magazine
 * @since  Rise Magazine 1.0.0
 * @return array An array of default values
 */

function rise_magazine_get_default_theme_options() {
	$theme_data = wp_get_theme();
	$rise_magazine_default_options = array(
		// Color Options
		'header_title_color'			    => '#fff',
		'header_tagline_color'			    => '#fff',
		'header_txt_logo_extra'			    => 'show-all',
		'colorscheme_hue'				    => '#d87b4d',
		'colorscheme'					    => 'default',
		'theme_version'						=> 'lite-version',
		'home_layout'						=> 'default-design',
	
		// loader
		'loader_enable'         		    => (bool) false,
		'loader_icon'         			    => 'default',

		// breadcrumb
		'breadcrumb_enable'				    => (bool) true,
		'breadcrumb_separator'			    => '/',
				
		// homepage options
		'enable_frontpage_content' 			=> false,

		// layout 
		'site_layout'         			    => 'wide',
		'sidebar_position'         		    => 'right-sidebar',
		'post_sidebar_position' 		    => 'right-sidebar',
		'page_sidebar_position' 		    => 'right-sidebar',
		'search_icon_in_primary_menu_enable'=> (bool) true,

		// excerpt options
		'long_excerpt_length'               => 25,

		// pagination options
		'pagination_enable'         	    => (bool) true,
		'pagination_type'         		    => 'default',

		// footer options
		'copyright_text'           		    => esc_html__( 'Copyright © 2022 ', 'rise-magazine' ) . esc_html( $theme_data->get( 'Name') ) . '&nbsp;' . esc_html__( 'by', 'rise-magazine' ). '&nbsp;<a target="_blank" href="'. esc_url( $theme_data->get( 'AuthorURI' ) ) .'">'. esc_html( ucwords( $theme_data->get( 'Author' ) ) ) .'</a>',
		'scroll_top_visible'        	    => (bool) true,
		'footer_social_menu_enable'      	=> (bool) false,

		// reset options
		'reset_options'      			    => (bool) false,

		// homepage sections sortable
		'pro_sortable' 						=> 'breaking_news,hero_banner,top_news,featured_article,post_slider,media_posts,latest_posts,related_posts',

	
		'default_sortable' 			    	=> 'breaking_news,hero_banner,top_news,featured_article,main_post,related_posts',

		// blog/archive options
		'your_latest_posts_title' 		    => esc_html__( 'Blogs', 'rise-magazine' ),
		'archive_btn_txt' 		    		=> esc_html__( 'Read More', 'rise-magazine' ),

		// single post theme options
		'single_post_hide_date' 		    => (bool) false,
		'single_post_hide_author'		    => (bool) false,
		'single_post_hide_category'		    => (bool) false,
		'single_post_hide_tags'			    => (bool) false,
		'single_post_hide_pagination'		=> (bool) false,
		'hide_category'			   			=> (bool) false,
		'hide_date'			   				=> (bool) false,

		/* Front Page */

		// Slider
		'post_slider_section_enable'		=> (bool) false,
		'post_slider_count'					=> 3,
		'post_slider_autoplay_enable'		=> (bool) false,
		'post_slider_title'           		=> esc_html__('Post Slider','rise-magazine'),
		
		// hero slider
		'hero_banner_section_enable'			=> (bool) false,
		'hero_banner_content_type'				=> 'post',
		'hero_banner_count'				 		=> 5,

		//featured article 
		'featured_article_section_enable'		   => (bool) false,
		'featured_article_title'    			   => esc_html__('Featured Article','rise-magazine'),
		'featured_article_count'				   => 3,
		'featured_article_excerpt_length'		   => 20,


		//related posts 
		'media_posts_section_enable'		 => (bool) false,
		'media_posts_title'    			  	 => esc_html__('Media Posts','rise-magazine'),
		'media_posts_count'				  	 => 5,
		'media_posts_excerpt_length'		 => 20,

		//related posts 
		'related_posts_section_enable'		   => (bool) false,
		'related_posts_title'    			   => esc_html__('Related Posts','rise-magazine'),
		'related_posts_count'				   => 4,

		//latest_post 
		'latest_posts_section_enable'		   => (bool) false,
		'latest_posts_title'    			   => esc_html__('Latest Posts','rise-magazine'),
		'latest_posts_count'				   => 4,
		'latest_posts_excerpt_length'		   => 20,

		
		//breaking_news 
		'breaking_news_section_enable'		 => (bool) false,
		'breaking_news_content_type'		 => 'post',
		'breaking_news_autoplay_enable'		 => (bool) false,
		'breaking_news_count'				 => 4,
		'breaking_news_title'    			 => esc_html__('Breaking News','rise-magazine'),
		
		//top_news 
		'top_news_section_enable'		  	 => (bool) false,
		'top_news_title'    			 	 => esc_html__('Top Stories','rise-magazine'),
		'top_news_count'				 	 => 4,

	);

	$output = apply_filters( 'rise_magazine_default_theme_options', $rise_magazine_default_options );

	// Sort array in ascending order, according to the key:
	if ( ! empty( $output ) ) {
		ksort( $output );
	}

	return $output;
}