<?php
/**
 * Excerpt options
 *
 * @package Theme Palace
 * @subpackage  Rise Magazine
 * @since  Rise Magazine 1.0.0
 */

// Add excerpt section
$wp_customize->add_section( 'rise_magazine_excerpt_section',
	array(
		'title'             => esc_html__( 'Excerpt','rise-magazine' ),
		'description'       => esc_html__( 'Excerpt section options.', 'rise-magazine' ),
		'panel'             => 'rise_magazine_theme_options_panel',
	)
);


// long Excerpt length setting and control.
$wp_customize->add_setting( 'rise_magazine_theme_options[long_excerpt_length]',
	array(
		'sanitize_callback' => 'rise_magazine_sanitize_number_range',
		'validate_callback' => 'rise_magazine_validate_long_excerpt',
		'default'			=> $options['long_excerpt_length'],
	)
);

$wp_customize->add_control( 'rise_magazine_theme_options[long_excerpt_length]',
	array(
		'label'       		=> esc_html__( 'Blog Page Excerpt Length', 'rise-magazine' ),
		'description' 		=> esc_html__( 'Total words to be displayed in archive page/search page.', 'rise-magazine' ),
		'section'     		=> 'rise_magazine_excerpt_section',
		'type'        		=> 'number',
		'input_attrs' 		=> array(
			'style'       => 'width: 80px;',
			'max'         => 100,
			'min'         => 5,
		),
	)
);
