<?php
/**
* Footer options
*
* @package Theme Palace
* @subpackage  Rise Magazine
* @since  Rise Magazine 1.0.0
*/

// Footer Section
$wp_customize->add_section( 'rise_magazine_section_footer',
	array(
		'title'      			=> esc_html__( 'Footer Options', 'rise-magazine' ),
		'priority'   			=> 900,
		'panel'      			=> 'rise_magazine_theme_options_panel',
		)
	);

// footer text
$wp_customize->add_setting( 'rise_magazine_theme_options[copyright_text]',
	array(
		'default'       		=> $options['copyright_text'],
		'sanitize_callback'		=> 'rise_magazine_santize_allow_tag',
		'transport'				=> 'postMessage',
	)
);

$wp_customize->add_control( 'rise_magazine_theme_options[copyright_text]',
	array(
		'label'      			=> esc_html__( 'Copyright Text', 'rise-magazine' ),
		'section'    			=> 'rise_magazine_section_footer',
		'type'		 			=> 'textarea',
	)
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial( 'rise_magazine_theme_options[copyright_text]',
		array(
			'selector'            => '.site-info .wrapper',
			'settings'            => 'rise_magazine_theme_options[copyright_text]',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
			'render_callback'     => 'rise_magazine_copyright_text_partial',
		)
	);
}


// scroll top visible
$wp_customize->add_setting( 'rise_magazine_theme_options[scroll_top_visible]',
	array(
		'default'       	=> $options['scroll_top_visible'],
		'sanitize_callback' => 'rise_magazine_sanitize_switch_control',
		)
	);

$wp_customize->add_control( new  Rise_Magazine_Switch_Control( $wp_customize,
	'rise_magazine_theme_options[scroll_top_visible]',
		array(
			'label'      		=> esc_html__( 'Display Scroll Top Button', 'rise-magazine' ),
			'section'    		=> 'rise_magazine_section_footer',
			'on_off_label' 		=> rise_magazine_switch_options(),
		)
	)
);
