<?php
/**
 * Reset options
 *
 * @package Theme Palace
 * @subpackage  Rise Magazine
 * @since  Rise Magazine 1.0.0
 */

/**
* Reset section
*/
// Add reset enable section
$wp_customize->add_section( 'rise_magazine_reset_section',
	array(
		'title'             => esc_html__('Reset all settings','rise-magazine'),
		'description'       => esc_html__( 'Caution: All settings will be reset to default. Refresh the page after clicking Save & Publish.', 'rise-magazine' ),
	)
);

// Add reset enable setting and control.
$wp_customize->add_setting( 'rise_magazine_theme_options[reset_options]',
	array(
		'default'           => $options['reset_options'],
		'sanitize_callback' => 'rise_magazine_sanitize_checkbox',
		'transport'			=> 'postMessage',
	)
);

$wp_customize->add_control( 'rise_magazine_theme_options[reset_options]',
	array(
		'label'             => esc_html__( 'Check to reset all settings', 'rise-magazine' ),
		'section'           => 'rise_magazine_reset_section',
		'type'              => 'checkbox',
	)
);
