<?php
/**
 * Banner section
 *
 * This is the template for the content of hero slider section
 *
 * @package Theme Palace
 * @subpackage  Rise Magazine
 * @since  Rise Magazine 1.0.0
 */
if ( ! function_exists( 'rise_magazine_add_hero_banner_section' ) ) :
    /**
    * Add slider section
    *
    *@since  Rise Magazine 1.0.0
    */
    function rise_magazine_add_hero_banner_section() {
    	$options = rise_magazine_get_theme_options();
        // Check if slider is enabled on frontpage
        $hero_banner_enable = apply_filters( 'rise_magazine_section_status', true, 'hero_banner_section_enable' );

        if ( true !== $hero_banner_enable ) {
            return false;
        }
        // Get slider section details
        $section_details = array();
        $section_details = apply_filters( 'rise_magazine_filter_hero_banner_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render slider section now.
        rise_magazine_render_hero_banner_section( $section_details );
}

endif;

if ( ! function_exists( 'rise_magazine_get_hero_banner_section_details' ) ) :
    /**
    * slider section details.
    *
    * @since  Rise Magazine 1.0.0
    * @param array $input slider section details.
    */
    function rise_magazine_get_hero_banner_section_details( $input ) {
        $options = rise_magazine_get_theme_options();

        // Content type.
        $hero_banner_content_type    = $options['hero_banner_content_type'];
        $hero_banner_count    = 5;
        
        $content = array();
        $post_ids = array();

        for ( $i = 1; $i <= $hero_banner_count; $i++ ) {
            if ( ! empty( $options['hero_banner_content_post_' . $i] ) )
                $post_ids[] = $options['hero_banner_content_post_' . $i];
        }
        
        $args = array(
            'post_type'             => 'post',
            'post__in'              => ( array ) $post_ids,
            'posts_per_page'        => absint( $hero_banner_count ),
            'orderby'               => 'post__in',
            'ignore_sticky_posts'   => true,
        );                    

       

        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            $i = 1;
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['excerpt']   = rise_magazine_trim_content( 30);
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'large' ) : get_template_directory_uri().'/assets/uploads/no-featured-image-600x450.jpg';

                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
            $i++;
        endif;
        wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// slider section content details.
add_filter( 'rise_magazine_filter_hero_banner_section_details', 'rise_magazine_get_hero_banner_section_details' );


if ( ! function_exists( 'rise_magazine_render_hero_banner_section' ) ) :
  /**
   * Start slider section
   *
   * @return string slider content
   * @since  Rise Magazine 1.0.0
   *
   */
   function rise_magazine_render_hero_banner_section( $content_details = array() ) {
        $options = rise_magazine_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } ?>
            <div id="magazine_pro_hero_section" class="relative">
                <div class="wrapper">
                    <div class="grid">
                    <?php foreach($content_details as $content) : ?>

                        <article class="grid-item">
                            <div class="featured-image" style="background-image: url('<?php echo esc_url($content['image']);?>');"></div>
                            <div class="entry-container">
                                <header class="entry-header">
                                    <h2 class="entry-title"><a href="<?php echo esc_url($content['url']);?>" tabindex="0"><?php echo esc_html($content['title']) ?></a></h2>
                                </header>

                                <div class="entry-meta">
                                    <span class="cat-links">
                                        <?php the_category('', '', $content['id'])?>
                                    </span><!-- .cat-links -->

                                <?php rise_magazine_posted_on($content['id']); ?>
                                </div><!-- .entry-meta -->
                            </div><!-- .entry-container -->
                        </article>
                        <?php endforeach; ?>
                    </div><!-- .grid-item -->
                </div><!-- .wrapper -->
            </div><!-- #hero-section -->
<?php
    }    
endif;