<?php
/**
 * Banner section
 *
 * This is the template for the content of slider section
 *
 * @package Theme Palace
 * @subpackage  Rise Magazine
 * @since  Rise Magazine 1.0.0
 */
if ( ! function_exists( 'rise_magazine_add_post_slider_section' ) ) :
    /**
    * Add slider section
    *
    *@since  Rise Magazine 1.0.0
    */
    function rise_magazine_add_post_slider_section() {
    	$options = rise_magazine_get_theme_options();
        // Check if slider is enabled on frontpage
        $post_slider_enable = apply_filters( 'rise_magazine_section_status', true, 'post_slider_section_enable' );

        if ( true !== $post_slider_enable ) {
            return false;
        }
        // Get slider section details
        $section_details = array();
        $section_details = apply_filters( 'rise_magazine_filter_post_slider_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render slider section now.
        rise_magazine_render_post_slider_section( $section_details );
}

endif;

if ( ! function_exists( 'rise_magazine_get_post_slider_section_details' ) ) :
    /**
    * slider section details.
    *
    * @since  Rise Magazine 1.0.0
    * @param array $input slider section details.
    */
    function rise_magazine_get_post_slider_section_details( $input ) {
        $options = rise_magazine_get_theme_options();

        // Content type.
        $post_slider_count  = 3;
        
        $content = array();
  
        $post_ids = array();

        for ( $i = 1; $i <= $post_slider_count; $i++ ) {
            if ( ! empty( $options['post_slider_content_post_' . $i] ) )
                $post_ids[] = $options['post_slider_content_post_' . $i];
        }
        
        $args = array(
            'post_type'             => 'post',
            'post__in'              => ( array ) $post_ids,
            'posts_per_page'        => absint( $post_slider_count ),
            'orderby'               => 'post__in',
            'ignore_sticky_posts'   => true,
        );                    
         
        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            $i = 1;
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'medium_large' ) : get_template_directory_uri().'/assets/uploads/no-featured-image-600x450.jpg';

                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
            $i++;
        endif;
        wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// slider section content details.
add_filter( 'rise_magazine_filter_post_slider_section_details', 'rise_magazine_get_post_slider_section_details' );


if ( ! function_exists( 'rise_magazine_render_post_slider_section' ) ) :
  /**
   * Start slider section
   *
   * @return string slider content
   * @since  Rise Magazine 1.0.0
   *
   */
   function rise_magazine_render_post_slider_section( $content_details = array() ) {
        $options = rise_magazine_get_theme_options();
        $post_slider_autoplay_enable = ($options['post_slider_autoplay_enable']) ? 'true' : 'false';

        if ( empty( $content_details ) ) {
            return;
        } ?>

            <div id="magazine_pro_posts_slider_section" class="relative">
                <?php if ( !empty( $options['post_slider_title'] ) ): ?>
                    <div class="section-header">
                        <h2 class="section-title"><?php echo esc_html( $options['post_slider_title'] ); ?></h2>
                    </div><!-- .section-header -->
                <?php endif ?>                

                <div class="featured-slider" data-slick='{"slidesToShow": 1, "slidesToScroll": 1, "infinite": true, "speed": 1000, "dots": false, "arrows":true, "autoplay": <?php echo esc_attr($post_slider_autoplay_enable); ?>, "draggable": true, "fade": false }'>
                <?php foreach ( $content_details as $i=>$content ) : ?>
                    <article style="background-image: url('<?php echo esc_url($content['image']); ?>');">
                        <div class="entry-container">
                            <div class="entry-meta">
                                <span class="cat-links">
                                    <?php the_category('', '', $content['id'])?>
                                </span><!-- .cat-links -->
                                <?php echo rise_magazine_author($content['id']); ?>
                            </div><!-- .entry-meta -->

                            <header class="entry-header">
                                <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                            </header>
                            <?php rise_magazine_posted_on($content['id']); ?>
                        </div><!-- .entry-container -->
                    </article>
                    <?php endforeach; ?>

                </div><!-- .featured-slider -->
            </div><!-- #magazine_pro_posts_slider_section -->
       
<?php
    }    
endif;