<?php
/**
 * Top Stories section
 *
 * This is the template for the content of Top Stories section
 *
 * @package Theme Palace
 * @subpackage  Rise Magazine
 * @since  Rise Magazine 1.0.0
 */                                                                                                                    
if ( ! function_exists( 'rise_magazine_add_top_news_section' ) ) :
    /**
    * Add Top Stories section
    *
    *@since  Rise Magazine 1.0.0
    */
    function rise_magazine_add_top_news_section() {
        $options = rise_magazine_get_theme_options();
        // Check if Top Stories is enabled on frontpage
        $top_news_enable = apply_filters( 'rise_magazine_section_status', true, 'top_news_section_enable' );

        if ( true !== $top_news_enable ) {
            return false;
        }
        // Get Top Stories section details
        $section_details = array();
        $section_details = apply_filters( 'rise_magazine_filter_top_news_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }
        // Render Top Stories section now.
        rise_magazine_render_top_news_section( $section_details );
    }
endif;

if ( ! function_exists( 'rise_magazine_get_top_news_section_details' ) ) :
    /**
    * Top Stories section details.
    *
    * @since  Rise Magazine 1.0.0
    * @param array $input top_news section details.
    */
    function rise_magazine_get_top_news_section_details( $input ) {
        $options = rise_magazine_get_theme_options();

        // Content type.
        $top_news_count = 4;
        
        $content = array();

        $post_ids = array();

        for ( $i = 1; $i <= $top_news_count; $i++ ) {
            if ( ! empty( $options['top_news_content_post_' . $i] ) )
                $post_ids[] = $options['top_news_content_post_' . $i];
        }
        
        $args = array(
            'post_type'             => 'post',
            'post__in'              => ( array ) $post_ids,
            'posts_per_page'        => absint( $top_news_count ),
            'orderby'               => 'post__in',
            'ignore_sticky_posts'   => true,
        );                    
         
        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'post-thumbnail' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-600x450.jpg';
                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// Top Stories section content details.
add_filter( 'rise_magazine_filter_top_news_section_details', 'rise_magazine_get_top_news_section_details' );


if ( ! function_exists( 'rise_magazine_render_top_news_section' ) ) :
  /**
   * Start Top Stories section
   *
   * @return string Top Stories content
   * @since  Rise Magazine 1.0.0
   *
   */
   function rise_magazine_render_top_news_section( $content_details = array() ) {
        $options                = rise_magazine_get_theme_options();
        
        if ( empty( $content_details ) ) {
            return;
        } ?>
            <div id="magazine_pro_top_news" class="relative page-section">
                <div class="wrapper">
                    <?php if ( !empty( $options['top_news_title'] ) ): ?>
                        <div class="section-header">
                            <h2 class="section-title"><?php echo esc_html( $options['top_news_title'] ); ?></h2>
                        </div><!-- .section-header -->
                    <?php endif ?>
                    
                    <div class="section-content col-4">
                    <?php foreach($content_details as $i=>$content) : ?>
                        <article>
                            <div class="featured-image" style="background-image: url('<?php echo esc_url($content['image']);?>');">
                                <a href="<?php echo esc_url($content['url']);?>" class="post-thumbnail-link"></a>

                                <span class="cat-links">
                                    <?php the_category('', '', $content['id'])?>
                                </span>
                            </div><!-- .featured-image -->

                            <div class="entry-container">
                                <div class="entry-meta">
                                    <?php rise_magazine_posted_on($content['id']); ?>
                                    <?php echo rise_magazine_author($content['id']); ?>
                                </div><!-- .entry-meta -->

                                <header class="entry-header">
                                    <h2 class="entry-title"><a href="<?php echo esc_url($content['url']);?>" tabindex="0"><?php echo esc_html($content['title']) ?></a></h2>
                                </header>
                            </div><!-- .entry-container -->
                        </article>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>

    <?php }
endif;  ?>
