<?php

/**
 * Theme Palace basic theme structure hooks
 *
 * This file contains structural hooks.
 *
 * @package Theme Palace
 * @subpackage  Rise Magazine
 * @since  Rise Magazine 1.0.0
 */

$options = rise_magazine_get_theme_options();


if (!function_exists('rise_magazine_doctype')) :
	/**
	 * Doctype Declaration.
	 *
	 * @since  Rise Magazine 1.0.0
	 */
	function rise_magazine_doctype()
	{
?>
		<!DOCTYPE html>
		<html <?php language_attributes(); ?>>
	<?php
	}
endif;
add_action('rise_magazine_doctype', 'rise_magazine_doctype', 10);


if (!function_exists('rise_magazine_head')) :
	/**
	 * Header Codes
	 *
	 * @since  Rise Magazine 1.0.0
	 *
	 */
	function rise_magazine_head()
	{
	?>
		<meta charset="<?php bloginfo('charset'); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<link rel="profile" href="https://gmpg.org/xfn/11">
		<?php if (is_singular() && pings_open(get_queried_object())) : ?>
			<link rel="pingback" href="<?php echo esc_url( get_bloginfo('pingback_url') ); ?>">
		<?php endif;
	}
endif;
add_action('rise_magazine_before_wp_head', 'rise_magazine_head', 10);

if (!function_exists('rise_magazine_page_start')) :
	/**
	 * Page starts html codes
	 *
	 * @since  Rise Magazine 1.0.0
	 *
	 */
	function rise_magazine_page_start()
	{
		?>
		<div id="page" class="site">
			<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e('Skip to content', 'rise-magazine'); ?></a>
		<?php
	}
endif;
add_action('rise_magazine_page_start_action', 'rise_magazine_page_start', 10);

if (!function_exists('rise_magazine_page_end')) :
	/**
	 * Page end html codes
	 *
	 * @since  Rise Magazine 1.0.0
	 *
	 */
	function rise_magazine_page_end()
	{
		?>
		</div><!-- #page -->
	<?php
	}
endif;
add_action('rise_magazine_page_end_action', 'rise_magazine_page_end', 10);

if (!function_exists('rise_magazine_site_branding')) :
	/**
	 * Site branding codes
	 *
	 * @since  Rise Magazine 1.0.0
	 *
	 */
	function rise_magazine_site_branding()
	{
		$options  = rise_magazine_get_theme_options();
		$header_txt_logo_extra = $options['header_txt_logo_extra'];	 ?>

		<div class="menu-overlay"></div>

		<header id="masthead" class="site-header" role="banner">
			<div class="site-branding-container">
				<div class="wrapper">
					<div class="site-branding-wrapper">

						<div class="site-branding">
							<?php if (in_array($header_txt_logo_extra, array('show-all', 'logo-title', 'logo-tagline')) && has_custom_logo()) : ?>
								<div class="site-logo">
									<?php the_custom_logo(); ?>
								</div>
							<?php endif;

							if (in_array($header_txt_logo_extra, array('show-all', 'title-only', 'logo-title', 'show-all', 'tagline-only', 'logo-tagline'))) : ?>
								<div id="site-identity">
									<?php
									if (in_array($header_txt_logo_extra, array('show-all', 'title-only', 'logo-title'))) {
										if (rise_magazine_is_latest_posts()) : ?>
											<h1 class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a></h1>
										<?php else : ?>
											<p class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a></p>
										<?php
										endif;
									}
									if (in_array($header_txt_logo_extra, array('show-all', 'tagline-only', 'logo-tagline'))) {
										$description = get_bloginfo('description', 'display');
										if ($description || is_customize_preview()) : ?>
											<p class="site-description"><?php echo esc_html($description); /* WPCS: xss ok. */ ?></p>
									<?php
										endif;
									} ?>
								</div><!-- .site-identity -->
							<?php endif; ?>
						</div><!-- .site-branding -->
						<?php if(!empty($options['ads_url']) && !empty($options['ads_image'])): ?>
							<div class="site-advertisement">
								<a href="<?php echo esc_url($options['ads_url']); ?>"><img src="<?php echo esc_url($options['ads_image']); ?>" alt="site-advertisement"></a>
							</div><!-- .site-advertisement -->
						<?php endif; ?> 
					</div><!-- .site-branding-wrapper -->
				</div><!-- .wrapper -->
			</div><!-- .site-branding-container -->

			<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false" title="Primary Menu">
				<?php
				echo rise_magazine_get_svg(array('icon' => 'menu', 'class' => 'icon-menu'));
				echo rise_magazine_get_svg(array('icon' => 'close', 'class' => 'icon-menu'));
				?>
				<span class="menu-label"><?php esc_html_e('Menu', 'rise-magazine') ?></span>
			</button>


			<nav id="site-navigation" class="main-navigation" role="navigation" aria-label="Primary Menu">
				<div class="wrapper">

					<?php if ($options['home_layout'] == 'fifth-design') echo '<div class="wrapper">'; ?>

					<?php
					$form_html = null;
						$form_html = sprintf('<li class="main-navigation-search">%1$s</li>', get_search_form(false));

					wp_nav_menu(
						array(
							'theme_location' => 'primary',
							'container' => 'div',
							'menu_class' => 'menu nav-menu',
							'menu_id' => 'primary-menu',
							'echo' => true,
							'fallback_cb' => 'rise_magazine_menu_fallback_cb',
							'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s' . $form_html . '</ul>',
						)
					);
					?>
				</div>
			</nav><!-- #site-navigation -->
		</header><!-- .header-->
	<?php
	}
endif;
add_action('rise_magazine_header_action', 'rise_magazine_site_branding', 10);

if (!function_exists('rise_magazine_content_start')) :
	/**
	 * Site content codes
	 *
	 * @since  Rise Magazine 1.0.0
	 *
	 */
	function rise_magazine_content_start()
	{
	?>
		<div id="content" class="site-content">
		<?php
	}
endif;
add_action('rise_magazine_content_start_action', 'rise_magazine_content_start', 10);

if (!function_exists('rise_magazine_header_image')) :
	/**
	 * Header Image codes
	 *
	 * @since  Rise Magazine 1.0.0
	 *
	 */
	function rise_magazine_header_image()
	{
		if (rise_magazine_is_frontpage())
			return;
		$header_image = get_header_image();
		if (is_singular()) :
			$header_image = has_post_thumbnail() ? get_the_post_thumbnail_url(get_the_id(), 'full') : $header_image;
		endif;
		$options  = rise_magazine_get_theme_options();
		?>

			<div id="page-site-header" class="relative" style="background-image: url('<?php echo esc_url($header_image); ?>');">
				<div class="overlay"></div>
				<div class="wrapper">
					<header class="page-header">
						<?php rise_magazine_custom_header_banner_title(); ?>
					</header>
					<?php rise_magazine_add_breadcrumb(); ?>
				</div>
			</div><!-- #page-site-header -->

		<?php
	}
endif;
add_action('rise_magazine_header_image_action', 'rise_magazine_header_image', 10);

if (!function_exists('rise_magazine_add_breadcrumb')) :
	/**
	 * Add breadcrumb.
	 *
	 * @since  Rise Magazine 1.0.0
	 */
	function rise_magazine_add_breadcrumb()
	{
		$options = rise_magazine_get_theme_options();

		// Bail if Breadcrumb disabled.
		$breadcrumb = $options['breadcrumb_enable'];
		if (false === $breadcrumb) {
			return;
		}

		// Bail if Home Page.
		if (rise_magazine_is_frontpage()) {
			return;
		}

		echo '<div id="breadcrumb-list" >';
		/**
		 * rise_magazine_simple_breadcrumb hook
		 *
		 * @hooked rise_magazine_simple_breadcrumb -  10
		 *
		 */
		do_action('rise_magazine_simple_breadcrumb');
		echo '</div><!-- #breadcrumb-list -->';
	}
endif;

if (!function_exists('rise_magazine_content_end')) :
	/**
	 * Site content codes
	 *
	 * @since  Rise Magazine 1.0.0
	 *
	 */
	function rise_magazine_content_end()
	{
		?>
		</div><!-- #content -->
	<?php
	}
endif;
add_action('rise_magazine_content_end_action', 'rise_magazine_content_end', 10);

if (!function_exists('rise_magazine_footer_start')) :
	/**
	 * Footer starts
	 *
	 * @since  Rise Magazine 1.0.0
	 *
	 */
	function rise_magazine_footer_start()
	{
	?>
		<footer id="colophon" class="site-footer" role="contentinfo">

		<?php
	}
endif;
add_action('rise_magazine_footer', 'rise_magazine_footer_start', 10);

if (!function_exists('rise_magazine_footer_site_info')) :
	/**
	 * Footer starts
	 *
	 * @since  Rise Magazine 1.0.0
	 *
	 */
	function rise_magazine_footer_site_info()
	{
		$options = rise_magazine_get_theme_options();

		$copyright_text = $options['copyright_text'];
		?>
			<div class="site-info">
				<div class="wrapper">
					<span>
						<?php
						echo rise_magazine_santize_allow_tag($copyright_text);
						if (function_exists('the_privacy_policy_link')) {
							the_privacy_policy_link(' | ');
						}
						?>
					</span>
				</div><!-- .wrapper -->
			</div><!-- .site-info -->

			<?php
		}
	endif;
	add_action('rise_magazine_footer', 'rise_magazine_footer_site_info', 40);

	if (!function_exists('rise_magazine_footer_scroll_to_top')) :
		/**
		 * Footer starts
		 *
		 * @since  Rise Magazine 1.0.0
		 *
		 */
		function rise_magazine_footer_scroll_to_top()
		{
			$options  = rise_magazine_get_theme_options();
			if (true === $options['scroll_top_visible']) : ?>
				<div class="backtotop"><?php echo rise_magazine_get_svg(array('icon' => 'up')); ?></div>
			<?php endif;
		}
	endif;
	add_action('rise_magazine_footer', 'rise_magazine_footer_scroll_to_top', 40);